<?php defined('BASEPATH') OR exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
require APPPATH.'/libraries/REST_Controller.php';
require APPPATH.'/third_party/Paginator.php';

class Reports extends CI_Controller
{
	public function __construct(){
		parent::__construct();
		$this->load->library(array('session','encrypt','eventlog','permissions','auth','locale'));
		$this->load->model('applicationmodel');
		$this->load->model('applicationrequestmodel');
		$this->load->model('requestmodel');
		$this->load->model('usersmodel');
		$this->load->model('loginsmodel');
		$this->load->model('mailmodel');
		$this->load->model('ticketsmodel');
		$this->load->model('ticketcategorymodel');
		$this->load->helper('url'); 
		date_default_timezone_set(ENVIRONMENT_TIMEZONE);

		//check if the user is authorized
		$login_status = $this->session->userdata('is_loggedin');
		if(!isset($login_status) || $login_status !== 'true') {
			//if the user has authenticated via CAC, the controller will load 
			//if not then a 401 Unauthorized error will be shown
			if(!$this->auth->perform_auth()) { show_error('Unauthorized',401); }
		}
		
		//check if user has agreed to dod banner
		$banner = $this->session->userdata('banner_agree');
		if (!isset($banner) || $banner !== 'true') {
			$this->session->set_flashdata('redirect_uri',uri_string());
			redirect('onboarding/banner');
		}
	}
	
	public function index() {
		//get user id from session to get permissions
		$id = $this->encrypt->decode($this->session->userdata('user_id'));
		$permissions = $this->permissions->get_user_permissions($id);
		$show = $this->permissions->set_tab_access_from_permissions($permissions);
		
		if(isset($show['reports']) && $show['reports']) { $this->report_requests(); }
		else { redirect('onboarding'); }
	}
	
	/* -----------------------------*
	 *  REPORTS TAB FUNCTIONS       *
	 * -----------------------------*/

	public function report_requests(){
		$pages = new Paginator('');
		$pages->page_setup($bar_page, $jump_page, $items_per_page, $destination_page);
		
		$data['title'] = 'Direct API: Reports';
		$data['active_tab'] = array('reports'=>true);
		$data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
		
		//get user id from session to get permissions
		$id = $this->encrypt->decode($this->session->userdata('user_id'));
		$permissions = $this->permissions->get_user_permissions($id);
		$data['show'] = $this->permissions->set_tab_access_from_permissions($permissions);
		
		if(!$data['show']['reports']) { show_error('Forbidden',403);  }
		$app_select = $this->input->post('whichapp',TRUE);//gets selected application
		if($app_select){//checks to see if there is an application selected.  This shows whether or not this is the first time the page has loaded.
			//adds each component type into its own json
			$selector = array(
				'application_id' => ($app_select),
			);
			
			$items = array(
				'id' => $this->search_type($this->input->post('request_id',TRUE),$this->input->post('request_id_type',TRUE)),
				'call' => $this->search_type($this->input->post('request_call',TRUE),$this->input->post('request_call_type',TRUE)),
				'response_code' => $this->search_type($this->input->post('request_code',TRUE),$this->input->post('request_code_type',TRUE)),
				'response' => $this->search_type($this->input->post('request_response',TRUE),$this->input->post('request_response_type',TRUE)),
			);
			
			$between = array(
				'call_date' => $this->check_date($this->input->post('start_date',TRUE),$this->input->post('end_date',TRUE)),
			);
			//get direction (desc/asc)and if it is being exported
			$dir = $this->direction_check($this->input->post('order',TRUE),$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
			$export = $this->input->post('export',TRUE);
			//calls helper to get data
			$response = $this->reports_helper('request',$items,$between,$selector,array(),$this->input->post('order',TRUE),$dir,$destination_page,$export,$items_per_page);
			$responses_list = $response['response'];
			//set form data
			$form_data = $this->input->post(NULL,TRUE);
			$form_data['direction'] = $dir;
			$form_data['cur_page'] = $destination_page;
			$size = $response['size'];
		}
		else{//if this is the first time you have loaded the page
			$responses_list = $this->requestmodel->get_first_responses($items_per_page)->result();//gets first page
			//set defaults
			$form_data = array(
			 'direction' => 'DESC',
			 'order' => 'call_date',
			 'cur_page' => '1',
			);
			//get number of items in log
			$size = $this->requestmodel->get_size()->result();
			$size = $size[0]->count;
			$export = false;
		}
		//set options for comparing
		$data['compare'] = array(
			'equals' => 'Equals',
			'contains' => 'Contains',
			'starts' => 'Starts With',
			'ends' => 'Ends With'
		);
		
		//pagination setup
		$pages->items_total = $size;
		$pages->current_page = $destination_page;
		$pages->paginate();
		$form_data['pagination_bar'] = $pages->display_pages();
		$form_data['items_per_page_dropdown'] = $pages->display_items_per_page();
		
		//gets image for asc or desc
		if($form_data['direction'] == 'DESC') { $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>'; }
		else { $data['image'] = '<img src="/images/arrow_up.png" style="border : 0; width:15px;" alt="Ascending"/>'; }
		
		$form_data['num_pages'] = ceil($size/$items_per_page); //num of log pages
		$form_data['items_per_page'] = $items_per_page;
		$form_data['pages'] = $pages;
		$data['form_data'] = $form_data;
		$data['apps'] = $this->applicationmodel->get_applications()->result();//gets all applications available
		$data['request_list'] = $responses_list;
		foreach($responses_list as $result) {
			//converts application's numbers into their names
			$name = $this->id_to_name(2,$result->application_id);
			$result->application_id=$name['id'];
		
			//set time in more readable format 
			if($result->call_date){ $result->call_date = date('m/d/y h:i:s A',$result->call_date); }
		}
		//if exported
		if ($export){  $this->export(array('ID','Application','Call','Date ('.$data['timezone_abbr'].')','Response Code','Response'),$responses_list,'response_log'); }
		//display on page
		else { $this->load->view('api/reports/requests', $data); }
	}
	
	//function for tickets report
	public function report_tickets(){
		$pages = new Paginator('');
		$pages->page_setup($bar_page, $jump_page, $items_per_page, $destination_page);
	
		$data['title'] = 'Direct API: Reports';
		$data['active_tab'] = array('reports'=>true);
		$data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
	
		//get user id from session to get permissions
		$id = $this->encrypt->decode($this->session->userdata('user_id'));
		$permissions = $this->permissions->get_user_permissions($id);
		$data['show'] = $this->permissions->set_tab_access_from_permissions($permissions);
	
		if(!$data['show']['reports']) { show_error('Forbidden',403);  }
		$category = $this->input->post('ticket_category',TRUE);//gets select ticket category
		if($category){//checks to see if there is an application selected.  This shows whether or not this is the first time the page has loaded.
			//adds each component type into its own json
			$selector = array(
					'category_id' => ($category),
			);
				
			$items = array(
					'id' => $this->search_type($this->input->post('ticket_id',TRUE),$this->input->post('ticket_id_type',TRUE)),
					'parent_id' => $this->search_type($this->input->post('ticket_parent',TRUE),$this->input->post('ticket_parent_type',TRUE)),
					'message' => $this->search_type($this->input->post('ticket_message',TRUE),$this->input->post('ticket_message_type',TRUE)),
			);
				
			$between = array(
					'open_date' => $this->check_date($this->input->post('open_start_date',TRUE),$this->input->post('open_end_date',TRUE)),
					'close_date' => $this->check_date($this->input->post('close_start_date',TRUE),$this->input->post('close_end_date',TRUE)),
			);
			
			$typesearch = array (
					'user_id' => array(
							'typesql' => null,
							'name' => $this->search_type($this->input->post('ticket_user',TRUE),$this->input->post('ticket_user_type',TRUE)),
							'type' => 3
					)
			);
			
			//get direction (desc/asc)and if it is being exported
			$dir = $this->direction_check($this->input->post('order',TRUE),$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
			$export = $this->input->post('export',TRUE);
			//calls helper to get data
			$response = $this->reports_helper('tickets',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$destination_page,$export,$items_per_page);
			$responses_list = $response['response'];
			//set form data
			$form_data = $this->input->post(NULL,TRUE);
			$form_data['direction'] = $dir;
			$form_data['cur_page'] = $destination_page;
			$size = $response['size'];
		}
		else{//if this is the first time you have loaded the page
			$responses_list = $this->ticketsmodel->get_first_responses($items_per_page)->result();//gets first page
			//set defaults
			$form_data = array(
				 'direction' => 'DESC',
				 'order' => 'open_date',
				 'cur_page' => '1',
			);
			//get number of items in log
			$size = $this->ticketsmodel->get_size()->result();
			$size = $size[0]->count;
			$export = false;
		}
		//set options for comparing
		$data['compare'] = array(
				'equals' => 'Equals',
				'contains' => 'Contains',
				'starts' => 'Starts With',
				'ends' => 'Ends With'
		);
	
		//pagination setup
		$pages->items_total = $size;
		$pages->current_page = $destination_page;
		$pages->paginate();
		$form_data['pagination_bar'] = $pages->display_pages();
		$form_data['items_per_page_dropdown'] = $pages->display_items_per_page();
	
		//gets image for asc or desc
		if($form_data['direction'] == 'DESC') { $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>'; }
		else { $data['image'] = '<img src="/images/arrow_up.png" style="border : 0; width:15px;" alt="Ascending"/>'; }
	
		$form_data['num_pages'] = ceil($size/$items_per_page); //num of log pages
		$form_data['items_per_page'] = $items_per_page;
		$form_data['pages'] = $pages;
		$data['form_data'] = $form_data;
		$data['categories'] = $this->ticketcategorymodel->get_categories()->result(); //gets all categories available
		$data['ticket_list'] = $responses_list;
		
		foreach($responses_list as $result) {
			
			//pull username from system (user type is 3)
			if ($result->user_id){
				$value = $this->id_to_name(3,$result->user_id);
				$result->user_id = $value['id'];
			}
			
			//pull category name from system (category type is is 5)
			if ($result->category_id){
				$value = $this->id_to_name(5,$result->category_id);
				$result->category_id = $value['id'];
			}
			
			//set time in more readable format
			if($result->open_date){ $result->open_date = date('m/d/y h:i:s A',$result->open_date); }
			if($result->close_date){ $result->close_date = date('m/d/y h:i:s A',$result->close_date); }
		}
		//if exported
		if ($export){  $this->export(array('ID','Parent','User','Message','Open Date ('.$data['timezone_abbr'].')','Close Date ('.$data['timezone_abbr'].')','Category'),$responses_list,'ticket_log'); }
		//display on page
		else { $this->load->view('api/reports/tickets', $data); }
	}
	
	//function for events report
	public function report_events(){
		$pages = new Paginator('');
		$pages->page_setup($bar_page, $jump_page, $items_per_page, $destination_page);
		
		$data['title'] = 'Direct API: Reports';
		$data['active_tab'] = array('reports'=>true);
		$data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
		
		//get user id from session to get permissions
		$id = $this->encrypt->decode($this->session->userdata('user_id'));
		$permissions = $this->permissions->get_user_permissions($id);
		$data['show'] = $this->permissions->set_tab_access_from_permissions($permissions);
		
		if(!$data['show']['reports']) { show_error('Forbidden',403); }
		$target_type = $this->input->post('target_type',TRUE);//gets selected 
		if($target_type){//checks to see if there is an application selected.  This shows whether or not this is the first time the page has loaded.
			//adds each component type into its own json
			$selector = array(
				'success' =>  $this->input->post('successful',TRUE),
			);
			
			$items = array(
				'id' => $this->search_type($this->input->post('event_id',TRUE),$this->input->post('event_id_type',TRUE)),
				'action' => $this->search_type($this->input->post('action',TRUE),$this->input->post('action_type',TRUE)),
			);
			
			$between = array(
				'event_date' => $this->check_date($this->input->post('start_date',TRUE),$this->input->post('end_date',TRUE)),
			);
			
			$typesearch = array (
				'actor_id'	=> array (
					'typesql' => 'actor_type',
					'name' => $this->search_type($this->input->post('acting_user',TRUE),$this->input->post('acting_user_type',TRUE)),
					'type' => $this->input->post('acting_type',TRUE),		
				),
				'target_id' => array(
					'typesql' => 'target_type',
					'name' => $this->search_type($this->input->post('target_user',TRUE),$this->input->post('target_user_type',TRUE)),
					'type' => $this->input->post('target_type',TRUE),
				),
			);
			//get direction and if it is supported
			$dir = $this->direction_check($this->input->post('order',TRUE),$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
			$export = $this->input->post('export',TRUE);
			
			//get data
			$response = $this->reports_helper('event',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$destination_page,$export,$items_per_page);
			$event_list = $response['response'];
			$form_data = $this->input->post(NULL,TRUE);
			$form_data['direction'] = $dir;
			$form_data['cur_page'] = $destination_page;
			$size = $response['size'];
			
			
		}
		else { //if this is the first time you have loaded the page (ie no filters have fields)
			$event_list = $this->eventmodel->get_first_events($items_per_page)->result();
			//set defaults
			$form_data = array(
			 'direction' => 'DESC',
			 'order' => 'event_date',
			 'cur_page' => '1',
			);
			//get number of items in log
			$size = $this->eventmodel->get_size()->result();
			$size = $size[0]->count;
			$export = FALSE;
		}
		//set options for comparing
		$data['compare'] = array(
			'equals' => 'Equals',
			'contains' => 'Contains',
			'starts' => 'Starts With',
			'ends' => 'Ends With'
		);
		
		//pagination setup
		$pages->items_total = $size;
		$pages->current_page = $destination_page;
		$pages->paginate();
		$form_data['pagination_bar'] = $pages->display_pages();
		$form_data['items_per_page_dropdown'] = $pages->display_items_per_page();
		
		//gets image for asc or desc
		if($form_data['direction'] == 'DESC') { $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>'; }
		else { $data['image'] = '<img src="/images/arrow_up.png" style="border : 0; width:15px;" alt="Ascending"/>'; }
		
		$form_data['num_pages'] = ceil($size/$items_per_page); //num of log pages
		$form_data['items_per_page'] = $items_per_page;
		$form_data['pages'] = $pages;
		$data['form_data'] = $form_data;
		$data['event_list'] = $event_list;
		
		
		foreach($event_list as $event) {
			//converts actor and target ids into their display names
			$value = $this->id_to_name($event->actor_type,$event->actor_id);
			$event->actor_type=$value['type'];
			$event->actor_id=$value['id'];
			$value = $this->id_to_name($event->target_type,$event->target_id);
			$event->target_type=$value['type'];
			$event->target_id=$value['id'];
			//changes success integer into true, false or unauth
			if($event->success === 1) { $event->success = 'TRUE'; }
			else if($event->success === 2){ $event->success = 'UNAUTH'; }
			else{ $event->success = 'FALSE'; }
			
			//change date into readable
			$event->event_date = date('m/d/y h:i:s A',$event->event_date);
			
		}
		if($export){ //if export
			$this->export(array('ID','Target Type','Target','Actor Type','Actor','Action','Date ('.$data['timezone_abbr'].')','Success'),$event_list,'events_log');
		}
		else{//else display
			$this->load->view('api/reports/events', $data);
		}

	}
	//function for logins report
	public function report_logins(){
		$pages = new Paginator('');
		$pages->page_setup($bar_page, $jump_page, $items_per_page, $destination_page);
		
		$data['title'] = 'Direct API: Reports';
		$data['active_tab'] = array('reports'=>true);
		$data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
		
		//get user id from session to get permissions
		$id = $this->encrypt->decode($this->session->userdata('user_id'));
		$permissions = $this->permissions->get_user_permissions($id);
		$data['show'] = $this->permissions->set_tab_access_from_permissions($permissions);
		
		if(!$data['show']['reports']) {
			show_error('Forbidden',403); 
		}
		$id_type = $this->input->post('id_type',TRUE); //gets selected 
		if($id_type) { // This shows whether or not this is the first time the page has loaded.
			//adds each component type into its own json
			$selector = array(
				'success' =>  $this->input->post('successful',TRUE),
			);
			
			$items = array(
				'id' => $this->search_type($this->input->post('id',TRUE),$this->input->post('id_type',TRUE)),
				'session_id'=>$this->search_type($this->input->post('session_id',TRUE),$this->input->post('session_id_type',TRUE)),
				'ip_address'=>$this->search_type($this->input->post('ip_address',TRUE),$this->input->post('ip_address_type',TRUE)),
				'error_msg'=>$this->search_type($this->input->post('message',TRUE),$this->input->post('message_type',TRUE)),
				'org_id'=>$this->search_type($this->input->post('org_id',TRUE),$this->input->post('org_id_type',TRUE)),
			);
			
			$between = array(
				'login_time' => $this->check_date($this->input->post('start_date',TRUE),$this->input->post('end_date',TRUE))
			);
			$typesearch = array (
				'org_id' => array(
					'typesql' => '',
					'name' => $this->search_type($this->input->post('username',TRUE),$this->input->post('username_type',TRUE)),
					'type' => 5
				)
			);
			//get direction and if exported
			$dir = $this->direction_check($this->input->post('order',TRUE),$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
			$export = $this->input->post('export',TRUE);
			//get data
			$response = $this->reports_helper('login',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$destination_page,$export,$items_per_page);
			$event_list = $response['response'];
			$form_data = $this->input->post(NULL,TRUE);
			$form_data['direction'] = $dir;
			$form_data['cur_page'] = $destination_page;
			$size = $response['size'];
		}
		else { //if this is the first time you have loaded the page (ie no filters have fields)
			$event_list = $this->loginsmodel->get_first_logins($items_per_page)->result();
			//set defaults
			$form_data = array(
			 'direction' => 'DESC',
			 'order' => 'login_time',
			 'cur_page' => '1'
			);
			//get number of items in log
			$size = $this->loginsmodel->get_size()->result();
			$size = $size[0]->count;
			$export = FALSE;
		}
		//set options for comparing
		$data['compare'] = array(
			'equals' => 'Equals',
			'contains' => 'Contains',
			'starts' => 'Starts With',
			'ends' => 'Ends With',
		);
		
		//pagination setup
		$pages->items_total = $size;
		$pages->current_page = $destination_page;
		$pages->paginate();
		$form_data['pagination_bar'] = $pages->display_pages();
		$form_data['items_per_page_dropdown'] = $pages->display_items_per_page();
		
		//gets image for asc or desc
		if($form_data['direction'] == 'DESC'){
			$data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
		}
		else{
			$data['image'] = '<img src="/images/arrow_up.png" style="border : 0; width:15px;" alt="Ascending"/>';
		}
		
		$form_data['num_pages'] = ceil($size/$items_per_page); //num of log pages
		$form_data['items_per_page'] = $items_per_page;
		$form_data['pages'] = $pages;
		$data['form_data'] = $form_data;
		$data['event_list'] = $event_list;
		//converts application's numbers into their names
		foreach($event_list as $event) {
			//convert org id to username
			$event->user_id=$this->usersmodel->get_username_from_org_id($event->org_id);
			//get binary true/false into text
			if($event->success === 1) { $event->success = 'TRUE'; }
			else { $event->success = 'FALSE'; }
			//convert data into readable formant.
			$event->login_time = date('m/d/y h:i:s A',$event->login_time);
			
		}
		//if export
		if($export) { $this->export(array('ID','Session ID','IP Address','Date ('.$data['timezone_abbr'].')','Success','Message','Org ID','Username'),$event_list,'logins_log'); }
		//else view
		else { $this->load->view('api/reports/logins', $data); }
	}
	
	//function for mail report
	public function report_mail(){
		$pages = new Paginator('');
		$pages->page_setup($bar_page, $jump_page, $items_per_page, $destination_page);
		
		$data['title'] = 'Direct API: Reports';
		$data['active_tab'] = array('reports'=>true);
		$data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
		
		//get user id from session to get permissions
		$id = $this->encrypt->decode($this->session->userdata('user_id'));
		$permissions = $this->permissions->get_user_permissions($id);
		$data['show'] = $this->permissions->set_tab_access_from_permissions($permissions);
		
		if(!$data['show']['reports']) {
			show_error('Forbidden',403); 
		}
		$successful = $this->input->post('sender_type',TRUE);//gets selected 
		if($successful){//checks to see if there is an application selected.  This shows whether or not this is the first time the page has loaded.
			//adds each component type into its own json
			$selector = array(
				'success' =>  $this->input->post('successful',TRUE),
				'mdn' =>  $this->input->post('mdn',TRUE),
				'inbound_outbound' => $this->input->post('bound',TRUE),
			);
			
			$items = array(
				'id' => $this->search_type($this->input->post('id',TRUE),$this->input->post('id_type',TRUE)),
				'size'=>$this->search_type($this->input->post('file_size',TRUE),$this->input->post('file_size_type',TRUE)),
				'attachment_types'=>$this->search_type($this->input->post('attachment_type',TRUE),$this->input->post('attachment_type_type',TRUE)),
				'sender'=>$this->search_type($this->input->post('sender',TRUE),$this->input->post('sender_type',TRUE)),
				'recipient'=>$this->search_type($this->input->post('recipient',TRUE),$this->input->post('recipient_type',TRUE)),
			);
			
			$between = array(
				'time' => $this->check_date($this->input->post('start_date',TRUE),$this->input->post('end_date',TRUE))
			);
			$typesearch = array (
			);
			$dir = $this->direction_check($this->input->post('order',TRUE),$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
			$export = $this->input->post('export',TRUE);
			$response = $this->reports_helper('mail',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$destination_page,$export,$items_per_page);
			$event_list = $response['response'];
			$form_data = $this->input->post(NULL,TRUE);
			$form_data['direction'] = $dir;
			$form_data['cur_page'] = $destination_page;
			$size = $response['size'];
		}
		else{//if this is the first time you have loaded the page (ie no filters have fields)
			$event_list = $this->mailmodel->get_first_mail($items_per_page)->result();
			//set defaults
			$form_data = array(
			 'direction' =>'DESC',
			 'order'=>'time',
			 'cur_page'=>'1',
			 'bound'=>'(ALL)',
			 'success'=>'(ALL)',
			);
			//get number of items in log
			$size = $this->mailmodel->get_size()->result();
			$size = $size[0]->count;
			$export = FALSE;
		}
		//set options for comparing
		$data['compare'] = array(
			'equals' => 'Equals',
			'contains' => 'Contains',
			'starts' => 'Starts With',
			'ends' => 'Ends With'
		);
		
		//pagination setup
		$pages->items_total = $size;
		$pages->current_page = $destination_page;
		$pages->paginate();
		$form_data['pagination_bar'] = $pages->display_pages();
		$form_data['items_per_page_dropdown'] = $pages->display_items_per_page();
		
		//gets image for asc or desc
		if($form_data['direction'] == 'DESC'){
			$data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
		}
		else{
			$data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>";
		}
		
		$form_data['num_pages'] = ceil($size/$items_per_page);//num of log pages
		$form_data['items_per_page'] = $items_per_page;
		$form_data['pages'] = $pages;
		$data['form_data'] = $form_data;
		$data['event_list'] = $event_list;
		//converts application's numbers into their names
		foreach($event_list as $event) {
			//get the recipients and convert to array
			$event->recipient=json_decode($event->recipient);
			$recip="";
			if(isset($event->recipient)){
				foreach($event->recipient as $key =>$value){
					//for all items after the first
					if($key>0){
						if($export){//if export make them comma seperated
							$recip.=", ";
						}
						else{//else when in view make each email on a line
							$recip.= "<br/>";
						}
					}
					$recip.= $value;//add email
				}
			}
			$event->recipient = $recip;
			//binary true/false into text
			if($event->success){
				$event->success = 'TRUE';
			}
			else {
				$event->success = 'FALSE';
			}
			//binary mdn into text
			if($event->mdn){
				$event->mdn = 'TRUE';
			}
			else {
				$event->mdn = 'FALSE';
			}
			//binary inbound/outbound into text
			if($event->inbound_outbound){
				$event->inbound_outbound = 'Inbound';
			}
			else {
				$event->inbound_outbound = 'Outbound';
			}
			//time in readable format
			$event->time = date("m/d/y h:i:s A",$event->time);
			
		}
		if($export){
			$this->export(array('ID','Date ('.$data['timezone_abbr'].')','Size(KB)','Sender','Recipient','Attachment Type','Success','Direction'),$event_list,'mail_log');
		}
		else{
			$this->load->view('api/reports/mail', $data);
		}

	}
	//converts the id into the name based on what type it is
	private function id_to_name($type,$id){
		$this->load->model('accountrequestmodel');
		$data=array();
		switch ($type){
			case 3://a user
				$name=$this->usersmodel->get_username_from_id($id);
				if($name){
					$data['id'] = $name;
				}
				else{
					$data['id'] = "N/A";
				}
				$data['type']="User";
				break;
			case 2://an application
				$name = $this->applicationmodel->get_application($id)->result();
				if($name){
					$data['id'] = $name[0]->name;
				}
				else{
					$data['id'] = "N/A";
				}
				$data['type'] = "Application";
				break;
			case 1://an application request
				$data['type'] = "App Request";
				$request = $this->applicationrequestmodel->get_request($id);
				if($request) {
					$name = $request->result();
					if($name){ $data['id'] = $name[0]->name; }
				}
				if(!isset($data['id'])) { $data['id'] = 'N/A'; }
				break;
			case 4://user request
				$data['type'] = "User Request";
				$request = $this->accountrequestmodel->get_request($id);
				if($request) {
					$name = $request->result();
					if($name){ $data['id'] = $name[0]->user_org_id; }
				}
				if(!isset($data['id'])) { $data['id'] = 'N/A'; }
				break;
			case 5://category
				$data['type'] = "Category";
				$request = $this->ticketcategorymodel->get_category($id);
				if($request) {
					$name = $request->result();
					if($name){ $data['id'] = $name[0]->category; }
				}
				if(!isset($data['id'])) { $data['id'] = 'N/A'; }
				break;
			case 6://user request
				$data['type'] = "Group";
				if(!isset($data['id'])) { $data['id'] = 'N/A'; }
				break;
		}
		return $data;
	}
	
	//chooses which (asc or desc) the table should be
	private function direction_check($order,$lastorder,$direction,$change){
		//reloaded by filter and not clicking to change direction.  also make sure that it was not changed by user
		if ($change == 'false' && ($direction == "DESC" || $direction == "ASC")){
			return $direction;
		}
		//colum selected is same as last
		if($order == $lastorder){
			if($direction == 'DESC'){
				return 'ASC';
			}
			else{
				return "DESC";
			}
		}
		//clicked on new colum
		else{ 
			return "DESC";
		}
	}
	
	//checks date is formated properly
	private function check_date($start,$end){
		$dates = array();
		//checks to see if start date is valid
		if(($st=strtotime($start)) == TRUE){
			$dates['start'] = $st;
		}
		else{
			$dates['start'] = null;//default to way back in the past
		}
		
		//checks to see if end date is valid
		if(($en=strtotime($end)) == TRUE){
			$dates['end'] = $en;//set to date plus one sec under 24 hours to get everything on that day
		}
		else{
			$dates['end'] = null;//default to tommorrow to include everything
		}
		return $dates;
	}
	//sets value of search based on what type of comparison
	private function search_type($value,$type){
		
		if($value == ''){//if no value ignore type
			return "%";
		}
		
		switch ($type){
			case 'equals':
				return $value;
				break;
			case 'contains':
				return "%".$value."%";
				break;
			case 'starts':
				return $value."%";
				break;
			case 'ends':
				return "%".$value;
				break;
			default:
				return $value;
				break;
		}
	}
	
	//gets the ids from each of the tabels to add  them to the query
	private function names_to_ids($idsql,$typesql,$name,$type){
		$this->load->model('accountrequestmodel');
		$sql = "";
		if($type == "3" || $type == "(ALL)"){//if it is a user
			if($typesql){
				$sql .= "(".$typesql." = 3 AND (";
			}
			else{
				$sql .= "((";
			}
			$add = "(2=1)";
			if($name=='%'){//if blank dont even search
				$add .= " OR (1 = 1)";
			}
			else{
				$results=$this->usersmodel->get_ids_from_username($name)->result();//search for ids like name
				foreach($results as $result){//add each username to 	
					$add .= " OR (".$idsql." = ". $result->user_id.")";
				}
			}
			$sql .=$add."))";
		}
		if($type == "2" || $type == "(ALL)"){//if application
			if($sql != ""){
				$sql .= " OR ";
			}
			if($typesql){
				$sql .= "(".$typesql." = 2 AND (";
			}
			else{
				$sql .= "((";
			}
			$add = "(2=1)";
			if($name=='%'){
				$add .= " OR (1 = 1)";
			}
			else{
				$results=$this->applicationmodel->get_ids($name)->result();
				foreach($results as $result){	
					$add .= " OR (".$idsql." = ". $result->id.")";
				}
			}
			$sql .=$add."))";
		}
		if($type == "1" || $type == "(ALL)"){//if application request
			if($sql != ""){
				$sql .= " OR ";
			}
			if($typesql){
				$sql .= "(".$typesql." = 1 AND (";
			}
			else{
				$sql .= "((";
			}
			$add = "(2=1)";
			if($name=='%'){
				$add .= " OR (1 = 1)";
			}
			else{
				$results=$this->applicationrequestmodel->get_ids($name)->result();
				foreach($results as $result){
					$add .= " OR (".$idsql." = ". $result->id.")";
				}
			}
			$sql .=$add."))";
			
		}
		if($type == "4" || $type == "(ALL)"){//if user request
			if($sql != ""){
				$sql .= " OR ";
			}
			if($typesql){
				$sql .= "(".$typesql." = 4 AND (";
			}
			else{
				$sql .= "((";
			}
			$add = "(2=1)";
			if($name=='%'){
				$add .= " OR (1 = 1)";
			}
			else{
				$results=$this->accountrequestmodel->get_ids($name)->result();
				foreach($results as $result){
					$add .= " OR (".$idsql." = ". $result->id.")";
				}
			}
			$sql .=$add."))";
			
		}
		if($type == "5"){//if user using org id
			if($name=='%'){
				$sql .='(1=1)';
			}
			else{
				$results=$this->usersmodel->get_orgs_from_username($name)->result();
				$sql.= "(2=1)";
				foreach($results as $result){	
					$sql .= " OR (".$idsql." = ". $result->user_org_id.")";
				}
			}
		}
		return $sql;
	}
	
	//generates and returns respose for filtered query
	private function reports_helper($table,$items,$between,$selector,$typesearch,$order,$dir,$page,$export,$items_per_page) {
		$sql = '0=0';//always true statment to start query
		//add each item to query
		foreach ($items as $key => $value){//this if for search field
			if($value!="%"){
				$sql = $sql." AND (". $key ." like ". $this->db->escape($value).")";
			}
		}
		foreach ($between as $key => $value){//this if for anything that has an upper and lower boundary (ie date)
			if($value['end']){
				$sql = $sql." AND (". $key ." <= ".$this->db->escape($value['end']).")";
			}
			if($value['start']){
				$sql = $sql." AND (". $key ." >= ".$this->db->escape($value['start']).")";
			}
			 
			
		}
		foreach ($selector as $key => $value){//this if for ones with a drop down menu
			if($value == "(ALL)"){
				$sql = $sql." AND (". $key ." like '%' OR ".$key." IS NULL)";
			}
			else{
				$sql = $sql." AND (". $key ." like ". $this->db->escape($value).")";
			}
		}
				
		foreach($typesearch as $key => $value){//this if for inputs that have different types and their ids refer to different entries on different tables
			if(!($value['type']=="(ALL)"&&$value['name']=="%")){
				$sql = $sql." AND (". $this->names_to_ids($key,$value['typesql'],$value['name'],$value['type']) .")";
			}
		}
		$order = str_replace("'","",$this->db->escape($order)). " ". $dir. ",id ". $dir ;//what to order values into
		//get starting point based on page number
		if(!$page){
			$page = 1;
		}
		$page = (($page-1)*$items_per_page)+1;
		switch($table){//choose what reports you are looking at
			case 'request':
				//get size
				$size = $this->requestmodel->get_filted_size($sql)->result();
				$size = $size[0]->count;
				if($export){//if export get all pages
					if(strpos($order, 'application_id') !== FALSE){//if sorting by application_id
						$responses_list = $this->requestmodel->get_request_filter_export_app_order($sql,$order)->result();
					}
					else{
						$responses_list = $this->requestmodel->get_request_filter_export($sql,$order)->result();
					}
				}
				else{
					//if you are on a page larger then what the size will be go back to first page
					if($size<$page){
						$page = 1;
					}
					if(strpos($order, 'application_id') !== FALSE){//if sorting by application_id
						$responses_list= $this->requestmodel->get_request_filter_app_order($sql,$order,$this->db->escape($page),$items_per_page)->result();
					}
					else{
						$responses_list= $this->requestmodel->get_request_filter($sql,$order,$this->db->escape($page),$items_per_page)->result();
					}
				}
				break;
			case 'event':
				$size = $this->eventmodel->get_filted_size($sql)->result();
				$size = $size[0]->count;
				if($export){//if export get all pages
					$responses_list = $this->eventmodel->get_event_filter_export($sql,$order)->result();
				}
				else{
					if($size<$page){//if you are on a page larger then what the size will be go back to first page
						$page = 1;
					}
					$responses_list= $this->eventmodel->get_event_filter($sql,$order,$this->db->escape($page),$items_per_page)->result();
				}
				break;
			case 'login':
				$size = $this->loginsmodel->get_filted_size($sql)->result();
				$size = $size[0]->count;
				
				if($export){//export get all pages
					if(strpos($order, 'user_id') !== FALSE){//ordered by user id
						$responses_list = $this->loginsmodel->get_login_filter_export_user_order($sql,$order)->result();
					}
					else{
						$responses_list = $this->loginsmodel->get_login_filter_export($sql,$order)->result();
					}
				}
				else{
					if($size < $page){//if you are on a page larger then what the size will be go back to first page
						$page = 1;
					}
					if(strpos($order, 'user_id') !== FALSE){//ordered by user id
						$responses_list= $this->loginsmodel->get_login_filter_user_order($sql,$order,$this->db->escape($page),$items_per_page)->result();
					}
					else{
						$responses_list= $this->loginsmodel->get_login_filter($sql,$order,$this->db->escape($page),$items_per_page)->result();
					}
				}
				break;
			case 'mail':
				$size = $this->mailmodel->get_filted_size($sql)->result();
				$size = $size[0]->count;
				if($export){ //export get all pages
					$responses_list = $this->mailmodel->get_mail_filter_export($sql,$order)->result();
				}
				else{
					if($size<$page){//if you are on a page larger then what the size will be go back to first page
						$page = 1;
					}
					$responses_list= $this->mailmodel->get_mail_filter($sql,$order,$this->db->escape($page),$items_per_page)->result();
				}
				break;	
			case 'tickets':
				$size = $this->ticketsmodel->get_filtered_size($sql)->result();
				$size = $size[0]->count;
				if($export){ //export get all pages
					if (strpos($order, 'user_id') !== FALSE){
						$responses_list = $this->ticketsmodel->get_tickets_filter_export_user_order($sql,$order)->result();
					}else if(strpos($order, 'category_id') !== FALSE){
						$responses_list = $this->ticketsmodel->get_tickets_filter_export_category_order($sql,$order)->result();
					}else{
						$responses_list = $this->ticketsmodel->get_tickets_filter_export($sql,$order)->result();
					}
				}
				else{
					if($size<$page){//if you are on a page larger then what the size will be go back to first page
						$page = 1;
					}
					if (strpos($order, 'user_id') !== FALSE){
						$responses_list= $this->ticketsmodel->get_tickets_filter_user_order($sql,$order,$this->db->escape($page),$items_per_page)->result();
					}else if(strpos($order, 'category_id') !== FALSE){
						$responses_list= $this->ticketsmodel->get_tickets_filter_category_order($sql,$order,$this->db->escape($page),$items_per_page)->result();
					}else{
						$responses_list= $this->ticketsmodel->get_tickets_filter($sql,$order,$this->db->escape($page),$items_per_page)->result();
					}
				}
				break;
			default: //tries to call a bad reports table
				//print_r ("Bad Table"); //debugging only
				//exit(-1); //debugging only
				break;
		}
		$response=array(
			'size'=>$size,
			'response'=>$responses_list
		);
		return $response;
		
	}
	
	/*
	 * export is used for exporting the results to excel 
	 */
	private function export($header,$results,$name){
		header('Content-Type: application/download'); 
		header('Content-Transfer-Encoding: binary');
        header('Content-Disposition: attachment; filename="'.$name.'.csv"');
		$fp = fopen('php://output', 'w');
		fputcsv($fp,  array('FOR OFFICIAL USE ONLY'));
		fputcsv ($fp, $header);
		foreach($results as $result) {
			$row=array();
			foreach($result as $part) {
				array_push($row,$part);
			}
			fputcsv ($fp, $row);
		}
		
		fclose($fp);
	}
}